/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/**
 * \file    uart.h
 *
 * \brief   uart Header File
 *
 * This header file contains the Macros definitions and Function declarations 
 * for uart test application
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created.
 */
/*========================
 * Includes
 *========================
 */
 
#include "DM814x_types.h"
#include "DM814x_EVM.h"
#include "DM814x_uart.h"

/* ------------------------------------------------------------------------ *
 *  UART Handle                                                             *
 * ------------------------------------------------------------------------ */
typedef UINT32 UART_Handle;

/* ------------------------------------------------------------------------ *
 *  UART IDs                                                                *
 * ------------------------------------------------------------------------ */
#define UART_0                  ( 0 )
#define UART_1                  ( 1 )
#define UART_2                  ( 2 )


/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
UART_Handle _UART_open( UINT16 id, UINT32 baudrate );
INT16       _UART_close( UART_Handle uart );

INT16 _UART_xmtReady( UART_Handle uart );
INT16 _UART_rcvReady( UART_Handle uart );

INT16 _UART_putChar( UART_Handle uart, UINT8 data );
INT16 _UART_getChar( UART_Handle uart, UINT8* data );

UINT32 _UART_rget( UART_Handle uart, UINT32 reg );
void   _UART_rset( UART_Handle uart, UINT32 reg, UINT32 reg_value );







